/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.client;

import al132.alib.client.CapabilityDisplayWrapper;
import al132.alib.container.ABaseContainer;
import al132.alib.tiles.ABaseTile;
import al132.alib.tiles.EnergyTile;
import java.text.NumberFormat;
import java.util.Locale;

public class CapabilityEnergyDisplayWrapper
extends CapabilityDisplayWrapper {
    public static NumberFormat numFormat = NumberFormat.getInstance(Locale.US);
    private ABaseContainer container = null;
    private ABaseTile tile = null;

    public CapabilityEnergyDisplayWrapper(int x, int y, int width, int height, ABaseContainer container) {
        super(x, y, width, height);
        this.container = container;
    }

    public CapabilityEnergyDisplayWrapper(int x, int y, int width, int height, ABaseTile tile) {
        super(x, y, width, height);
        this.tile = tile;
    }

    @Override
    public int getStored() {
        if (this.container != null) {
            return this.container.getEnergy();
        }
        if (this.tile != null) {
            return ((EnergyTile)((Object)this.tile)).getEnergy().getEnergyStored();
        }
        return -1;
    }

    @Override
    public int getCapacity() {
        if (this.container != null) {
            return this.container.getEnergyCapacity();
        }
        if (this.tile != null) {
            return ((EnergyTile)((Object)this.tile)).getEnergy().getMaxEnergyStored();
        }
        return -1;
    }

    public String toString() {
        String stored = numFormat.format(this.getStored());
        String capacity = numFormat.format(this.getCapacity());
        String tooltip = stored + "/" + capacity + " FE";
        return tooltip;
    }
}

